/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPSECURECONFIGURATION_P_H
#define QKNXNETIPSECURECONFIGURATION_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt KNX API.  It exists for the convenience
// of the Qt KNX implementation.  This header file may change from version
// to version without notice, or even be removed.
//
// We mean it.
//

#include <QtKnx/qknxaddress.h>
#include <QtKnx/qknxnetip.h>
#include <QtKnx/qknxsecurekey.h>

QT_BEGIN_NAMESPACE

class QKnxNetIpSecureConfigurationPrivate : public QSharedData
{
public:
    QKnxNetIpSecureConfigurationPrivate() = default;
    ~QKnxNetIpSecureConfigurationPrivate() = default;

    QKnxSecureKey privateKey;
    QKnxSecureKey publicKey;
    QKnxAddress host;
    QKnxNetIp::SecureUserId userId { QKnxNetIp::SecureUserId::Reserved };
    QByteArray userPassword;
    QKnxAddress ia;
    QByteArray deviceAuthenticationCode;
    bool keepAlive { false };
};

QT_END_NAMESPACE

#endif
